--------------------------------------------------------------------------------------------------------------
------------------------  Many to One ------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------
/*
Generating a single SQL command using multiple lines of code.

1. Write the SQL statement first.
2. Declare a variable to store the code, 
	and convert the code into a string.
3. Convert any literals that need to become dynamic into fields.
	a. Double any quotes
	b. Declare any variables that are going to need
	c. Replace anything you want to make dynamic with '++' 
		then plug in the column/formula/variable.
	d. Include schema names
	e. QUOTENAME is your friend.
4. Copy the results to a query window.
5. Test
	a. Parse
	b. Run a SINGLE command, preferrably in a transaction to test for correctness.
	c. Run the rest of the commands in a transaction if possible.
6. After each failed test make one (or sometimes two) corrections and test again.
*/
USE [Dynamic SQL Session];
GO

DECLARE @Login nvarchar(100)
DECLARE @Type nvarchar(100) = 'S'
DECLARE @is_disabled int = 1
DECLARE @default_database_name nvarchar(200)

SELECT principal_id AS SrvPrincipalId, name AS SrvPrincipal, type, type_desc,  
		is_disabled, default_database_name, default_language_name, sid 
FROM sys.server_principals Logins 
WHERE 
-- Can't use an index
	Logins.name = ISNULL(@Login, Logins.name) 
  AND Logins.type = ISNULL(@Type,Logins.type)
-- Can use indexes but not always as efficiently.
  AND (@default_database_name IS NULL OR Logins.default_database_name = @default_database_name)
  AND (@is_disabled IS NULL OR Logins.is_disabled = @is_disabled)	
GO














----------------------------------------------------------------------------------
DECLARE @sql nvarchar(max)
DECLARE @Login nvarchar(100)
DECLARE @Type nchar(1) = N'S'
DECLARE @default_database_name nvarchar(200)
DECLARE @is_disabled int = 0

SET @sql = 
N'SELECT principal_id AS SrvPrincipalId, name AS SrvPrincipal, type, type_desc, is_disabled, 
          default_database_name, default_language_name, sid 
FROM sys.server_principals Logins 
WHERE 1=1 '




    
IF LEN(@Login) > 0 
	SET @sql = @sql + NCHAR(13) + N'  AND Logins.name = @Login'

IF LEN(@Type) > 0
	SET @sql = @sql + NCHAR(13) + N'  AND Logins.type = @Type'
  
IF LEN(@default_database_name) > 0
	SET @sql = @sql + NCHAR(13) + N'  AND Logins.type = @default_database_name'

IF LEN(@is_disabled) > 0
	SET @sql = @sql + NCHAR(13) + N'  AND Logins.is_disabled = @is_disabled'

--PRINT @sql
EXEC sp_executesql @sql, 
	N'@Login nvarchar(100), @Type nchar(1) = ''S'', 
	@default_database_name nvarchar(200), @is_disabled int = 0',
	@Login, @Type, @default_database_name, @is_disabled
